package com.hero.objects.modifiers;

import java.util.ArrayList;

import org.jdom.Element;

import com.hero.HeroDesigner;
import com.hero.objects.Adder;
import com.hero.objects.GenericObject;
import com.hero.objects.powers.EnduranceReserve;
import com.hero.objects.powers.EnduranceReserveRecovery;
import com.hero.objects.powers.Power;

/**
 * Copyright (c) 2000 - 2005, CompNet Design, Inc. All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, is prohibited unless the following conditions are met: 1.
 * Express written consent of CompNet Design, Inc. is obtained by the developer.
 * 2. Redistributions must retain this copyright notice. THIS SOFTWARE IS
 * PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * @author CompNet Design, Inc.
 * @version $Revision$
 */

public class CostsEND extends Modifier {

	private static String xmlID = "COSTSEND";

	public CostsEND(Element root) {
		super(root, CostsEND.xmlID);
	}

	@Override
	public String getColumn2Output() {
		String adderString = "";
		String ret = "";
		ret += getAlias();
		if (getSelectedOption() != null && getSelectedOption().getXMLID().equals("HALFEND")) {
			ret = getSelectedOption().getAlias();
		}
		double val = getTotalValue();
		if ((getInput() != null) && (getInput().trim().length() > 0)) {
			if (ret.trim().length() > 0) {
				ret += " ";
			}
			ret += getInput();
		}
		ret = ret.trim();
		for (Modifier mod : getAssignedModifiers()) {
			ret += ", " + mod.getAlias();
		}
		if ((getSelectedOption() != null)
				&& getSelectedOption().displayInString()
				&& (getSelectedOption().getAlias().trim().length() > 0)) {
			ret += " (" + getSelectedOption().getAlias();
		}
		int index = 0;
		int parenCount = 0;
		while (ret.indexOf("(", index) >= 0) {
			parenCount++;
			index = ret.indexOf("(", index) + 1;
		}
		index = 0;
		while (ret.indexOf(")", index) >= 0) {
			parenCount--;
			index = ret.indexOf(")", index) + 1;
		}
		if (parenCount <= 0) {
			ret += " (";
		} else {
			ret += "; ";
		}
		for (Adder ad : getAssignedAdders()) {
			if (!ad.isSelected()) {
				continue;
			}
			if (ad.getColumn2Output().trim().length() > 0) {
				ret += ad.getColumn2Output().trim() + "; ";
			}
		}
		if (getComments().trim().length() > 0) {
			ret += getComments() + "; ";
		}
		if ((val > maxCost) && maxSet) {
			val = maxCost;
		}
		if ((val < minimumCost) && minSet) {
			val = minimumCost;
		}
		ret += getFraction(val) + ")";
		parenCount--;
		while (parenCount > 0) {
			ret += ")";
			parenCount--;
		}
		if (adderString.trim().length() > 0) {
			if (ret.trim().length() > 0) {
				ret += ", ";
			}
			ret += adderString;
		}
		return ret;
	}

	@Override
	public ArrayList<Adder> getOptions() {
		ArrayList<Adder> ret = super.getOptions();
		if ((getProgenitor() == null) || !(getProgenitor() instanceof Power)) {
			return ret;
		}
		GenericObject p = getProgenitor();
		if (p.getDuration().equals("INSTANT")) {
			if (HeroDesigner.getActiveTemplate().is6E()) {
				ArrayList<Adder> ret2 = new ArrayList<Adder>();
				for (Adder ad : ret) {
					if (ad.getXMLID().equals("INSTANT")) {
						continue;
					}
					ret2.add(ad);
				}
				if (getSelectedOption() != null
						&& getSelectedOption().getXMLID().equals("ACTIVATE")) {
					setSelectedOption(ret2.get(0));
				}
				return ret2;
			} else {
				setSelectedOption(null);
				baseCost = origBaseCost;
				return new ArrayList<Adder>();
			}
		}
		return ret;
	}

	@Override
	public Adder getSelectedOption() {
		Adder ret = super.getSelectedOption();
		if ((getProgenitor() == null) || !(getProgenitor() instanceof Power)) {
			return ret;
		}
		GenericObject p = getProgenitor();
		if (p.getDuration().equals("INSTANT") && !p.continuingEffect()) {
			if (HeroDesigner.getActiveTemplate().is6E()) {
				if (selectedOption != null
						&& selectedOption.getXMLID().equals("ACTIVATE") && options != null && options.size() > 0) {
					setSelectedOption(options.get(0));
				}
			} else {
				baseCost = origBaseCost;
				return null;
			}
		}
		return ret;
	}

	@Override
	public String included(GenericObject o) {
		String ret = super.included(o);
		if (ret.trim().length() > 0) {
			return ret;
		}

        if (forceAllow()) return ret;
		if ((o instanceof EnduranceReserve)
				|| (o instanceof EnduranceReserveRecovery)) {
			return getDisplay()
					+ " cannot be applied to an Endurance Reserve or its Recovery.";
		}
		if (GenericObject.findObjectByID(o.getAssignedModifiers(),
				"NONPERSISTENT") != null
				&& !HeroDesigner.getActiveTemplate().is6E()) {
			return getDisplay()
					+ " cannot be applied to an ability with the non-Persistent Limitation.";
		}
		if (GenericObject
				.findObjectByID(o.getAssignedModifiers(), "REDUCEDEND") != null) {
			return getDisplay()
					+ " cannot be applied to an ability with Reduced END.";
		}
		if (GenericObject.findObjectByID(o.getAssignedModifiers(),
				"COSTSENDONLYTOACTIVATE") != null) {
			return getDisplay()
					+ " cannot be applied to an ability with Costs END Only To Activate.";
		}
		if (GenericObject.findObjectByID(o.getAssignedModifiers(),
				"COSTSENDTOMAINTAIN") != null) {
			return getDisplay()
					+ " cannot be applied to an ability with Costs END To Maintain.";
		}
		if (o.getEndUsage() == 0) {
			return "";
		} else {
			return getDisplay()
					+ " cannot be applied to an ability which already costs END.";
		}
	}
}